class RedPhotonBomb extends PhotonBomb;

var name damageType;			// type of damage that this projectile does
var float	mpBlastRadius;
var() bool           bDamaged;         // was this blown up via damage?

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local RFCEffect sphere;
   local ExplosionSmall expeffect;

	// draw a pretty explosion
	light = Spawn(None,,, HitLocation);
	if (light != None)
	{
      if (!bDamaged)
         light.RemoteRole = ROLE_None;
		light.size = 8;
		light.LightHue = 128;
		light.LightSaturation = 96;
		light.LightEffect = LE_Shell;
	}

	expeffect = Spawn(None,,, HitLocation);
   if ((expeffect != None) && (!bDamaged))
      expeffect.RemoteRole = ROLE_None;

	// draw a cool light sphere
	sphere = Spawn(class'Markistan.RFCEffect',,, HitLocation);
	if (sphere != None)
   {
      if (!bDamaged)
         sphere.RemoteRole = ROLE_None;
		sphere.size = blastRadius / 32.0;
   }
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		blastRadius=mpBlastRadius;
		bIgnoresNanoDefense=True;
	}
}

function Tick(float Deltatime)
{
}

defaultproperties
{
     DamageType=Disintegrated
     mpBlastRadius=160.000000
     fuseLength=1.500000
     bStickToWall=True
     blastRadius=160.000000
     ItemName="Red Photon Bomb"
     Damage=125.000000
     ExplosionDecal=Class'Markistan.PhotonMarkRed'
     Texture=FireTexture'Effects.liquid.Virus_SFX'
     Skin=FireTexture'Effects.liquid.Virus_SFX'
     DrawScale=0.150000
     MultiSkins(0)=FireTexture'Effects.liquid.Virus_SFX'
     LightSaturation=50
     LightBrightness=12.5
     LightRadius=25
}
